/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.soulshardsrespawn.compat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.creeperhost.soulshardsrespawn.compat.jei.MultiBlockDrawable;
import net.creeperhost.soulshardsrespawn.core.RegistrarSoulShards;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class MultiblockCategory
implements IRecipeCategory<Recipe> {
    public static final Component TITLE = new TextComponent("Soul Shard Crafting");
    public static final RecipeType<Recipe> SOUL_SHARD_CRAFTING = RecipeType.create((String)"soulshards", (String)"soulshardcrafting", Recipe.class);
    private final IGuiHelper iGuiHelper;
    private final IDrawable multiblock;
    private final IDrawable arrowRight;

    public MultiblockCategory(IGuiHelper iGuiHelper) {
        this.iGuiHelper = iGuiHelper;
        IDrawable obsidian = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50080_));
        IDrawable quartz = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50333_));
        IDrawable glowstone = iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Blocks.f_50141_));
        this.multiblock = new MultiBlockDrawable(obsidian, glowstone, quartz);
        this.arrowRight = iGuiHelper.drawableBuilder(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 82, 128, 24, 17).build();
    }

    @NotNull
    public RecipeType<Recipe> getRecipeType() {
        return SOUL_SHARD_CRAFTING;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.iGuiHelper.createBlankDrawable(114, 131);
    }

    @NotNull
    public IDrawable getIcon() {
        return this.iGuiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistrarSoulShards.SOUL_SHARD));
    }

    public void draw(@NotNull Recipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull PoseStack stack, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.multiblock.draw(stack, 10, 30);
        this.arrowRight.draw(stack, 60, 30);
        Font font = Minecraft.m_91087_().f_91062_;
        font.m_92883_(stack, "Right-click on the top", 2.0f, 70.0f, 0);
        font.m_92883_(stack, "of the " + ChatFormatting.DARK_PURPLE + "Glowstone Block", 2.0f, 80.0f, 0);
        font.m_92883_(stack, "with a " + ChatFormatting.DARK_PURPLE + recipe.getInput().m_41786_().getString() + ChatFormatting.BLACK + " in hand", 2.0f, 90.0f, 0);
        RenderSystem.m_69461_();
    }

    @NotNull
    public List<Component> getTooltipStrings(@NotNull Recipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (this.isInRect(10, 30, 40, 36, mouseX, mouseY)) {
            components.add((Component)new TextComponent("4x " + Blocks.f_50080_.m_49954_().getString()));
            components.add((Component)new TextComponent("4x " + Blocks.f_50333_.m_49954_().getString()));
            components.add((Component)new TextComponent("1x " + Blocks.f_50141_.m_49954_().getString()));
        }
        return components;
    }

    public ResourceLocation getUid() {
        return SOUL_SHARD_CRAFTING.getUid();
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public boolean isInRect(int x, int y, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX <= (double)(x + xSize) && mouseY >= (double)y && mouseY <= (double)(y + ySize);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 23, 1).addItemStack(recipe.getInput());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 30).addItemStack(recipe.getOutput());
    }

    public static class Recipe {
        private final ItemStack input;
        private final ItemStack output;

        public Recipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }

        public ItemStack getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            return this.output;
        }
    }
}

